<?php
class Template
{
    public $name, $title, $meta, $headingColor; // head tag data
    public $nav;    // (sitemap) header tag data - body tag
    
    function __construct ($name, $title, $meta) 
    {
        $this->name = $name;
        $this->title = $title;
        $this->meta = $meta;
        $this->nav = array ("About Us"=>"about_us", "Our Team"=>"team", "Careers"=>"careers", "Contact Us"=>"contact" );
        $this->headingColor = "#000";
    }

    function printPage ()
    {
        echo ("<!DOCTYPE html>\n");
        echo ('<html lang="en-GB">'."\n");
        $this->printHead();
        echo ('<body style="background: white;">');
        $this->printHeaderMain();
        $this->printHeaderMarquee();
        $this->printMainContent();
        if ($this->name != "privacy" && $this->name != "contact")
            $this->printSectionTKOSP();
        $this->printFooterMain();
        $this->printFooterSticky();
        $this->printWAWidget();
        echo ('</body>'."\n");
        echo ('</html>');
    }

    function printHead ()
    {
        $head = "<head";
        if ($this->name == "index")
            $head .= ' class="at-element-marker"';
        $head .= ">";
        ?>
        <!-- BEGIN HEAD -->
        <?php echo ($head."\n"); ?>
            <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
            <meta http-equiv="X-UA-Compatible" content="IE=edge">
    
            <meta name="keywords" content="lawyer, risk management, legal advice, lawyers, law firm, financial advice, financial advisors, tax lawyers, real estate lawyers, insurance lawyers, corporate lawyers, kenyan lawyers, commercial lawyers, financial regulation, insurance advice, kenyan law firm, law firm, real estate advisors, legal advisors, lawyer training, industrial lawyers, legal support, nairobi law firm, finance lawyers, equity advice, legal insight, global lawyers, legal expertise, trade lawyers, corporate advice, regulatory advice, public sector lawyers, acquisition advice, yonga and simiyu, yonga & simiyu">
            <meta name="description" content="We are one of the world&#39;s pre-eminent law firms, with significant depth and range of resources across five continents.">
            <meta name="viewport" content="width=device-width, initial-scale=1">
            <meta name="robots" content="noarchive">
            <meta name="robots" content="follow">
            <meta name="twitter:card" content="summary_large_image">
            <meta property="og:title" content="<?php echo ($this->title); ?>">
            <meta name="twitter:title" content="<?php echo ($this->title); ?>">
            <meta property="og:description" content="We are a registered Kenyan Law Firm with significant partnerships across East Africa and broadening our reach.">
            <meta name="twitter:description" content="We are a registered Kenyan Law Firm with significant partnerships across East Africa and broadening our reach.">
            <meta property="og:url" content="#/content/yongaandsimiyu/about_us.html">
            <meta property="og:image" content="#/content/dam/yongaandsimiyu/social-media-images/2023/08/rbr-social-sharing.jpg">
            <meta name="twitter:image" content="#/content/dam/yongaandsimiyu/social-media-images/2023/08/rbr-social-sharing.jpg">
            <meta property="og:site_name" content="Yonga & Simiyu">
            <meta name="twitter:site" content="@yongaandsimiyu">

            <script type="text/plain" async="" src="js/js" nonce="" class="optanon-category-C0002 "></script>
            <script async="" src="js/insight.old.min.js"></script>
            <script type="text/javascript" async="" src="js/insight.min.js"></script>
            <script defer="defer" type="text/javascript" src="js/rum-standalone.js" data-routing="env=prod,tier=publish,ams=Yonga & Simiyu LLP (Enterprise)"></script>
            
            <?php echo ('<link rel="canonical" href="'.$this->name.'.php">'); ?>
            
            <title><?php if ($this->name == "index") $this->title .= " | Kenyan Law Firm | EA Region Law Experts"; echo ($this->title); ?></title>
            
            <meta content="Bernard Katiku Mutua - +254708793131 - katikumut@gmail.com" name="author"/>

            <link href="css/desktop.css" rel="stylesheet" type="text/css" media="screen, print">
            <link href="css/style.css" rel="stylesheet" media="screen, print">
            <link href="css/style.css" rel="stylesheet" media="print">
            <link href="css/print.css" rel="stylesheet" type="text/css" media="print">
            <link href="css/cc-cc.css" rel="stylesheet" type="text/css" media="screen">
            <link href="css/cp-home.css" rel="stylesheet" type="text/css" media="screen">
            <link href="css/cp-prefs.css" rel="stylesheet" type="text/css" media="screen">
            <link href="css/cbg.css" rel="stylesheet" type="text/css" media="screen">
            <link href="css/www-player.css" rel="stylesheet" type="text/css" media="screen">

            <link rel="apple-touch-icon" href="img/favjpg.jpg" type="image/jpg">
            <link rel="shortcut icon" href="img/favjpg.jpg" type="image/jpg">
            <link rel="icon" href="img/favjpg.jpg" type="image/jpg">

            <?php
            if ($this->name == "team") {
                ?>
                <script type="text/javascript" id="www-widgetapi-script" src="js/youtubesupport.js" async=""></script>
                <script async="" src="js/gtm.js"></script>
                <script id="yt-iframe-api" src="js/youtube.js"></script>
                <?php
            }            
            ?>

            <?php $this->printPageStyle(); ?>

            <script type="text/javascript" src="js/jquery191.js"></script>
            <script type="text/javascript" src="js/jqueryui.js"></script>
            <script type="text/javascript" src="js/jqueryuitouchpunch.js"></script>
            <script type="text/javascript" src="js/jquerycookies.js"></script>
            <script type="text/javascript" src="js/jquerycolor.js"></script>    
            <script type="text/javascript" src="js/jquery-mobile.js"></script>
            <script type="text/javascript" src="js/respond.js"></script>
            <script type="text/javascript" src="js/hoverintent.js"></script>
            <script type="text/javascript" src="js/nav.js"></script>
            <script type="text/javascript" src="js/article.js"></script>
            <script type="text/javascript" src="js/analyticsdata.js"></script>
            <!-- <script async src="https://siteimproveanalytics.com/js/siteanalyze_10168.js"></script> -->
            <script type="text/javascript" src="js/cp-home.js"></script>
            <script type="text/javascript" src="js/cp-prefs.js"></script>
            <script type="text/javascript" src="js/cp-okta.js"></script>
            <script type="text/javascript" src="js/cbg.js"></script>            
            <script type="text/javascript" src="js/article(1).js"></script>
            <script type="text/javascript" src="js/inputValidation.js"></script>
            <!--------------------- YOUTUBE VIDEO TRACKING --------------------->            
        </head>
        <!-- END HEAD -->
        <?php
    }

    function printWAWidget () {
        echo ('<script>!function(){var e,t,n,a;window.MyAliceWebChat||((t=document.createElement("div")).id="myAliceWebChat",(n=document.createElement("script")).type="text/javascript",n.async=!0,n.src="https://widget.myalice.ai/index.js",(a=(e=document.body.getElementsByTagName("script"))[e.length-1]).parentNode.insertBefore(n,a),a.parentNode.insertBefore(t,a),n.addEventListener("load",(function(){MyAliceWebChat.init({selector:"myAliceWebChat",number:"254795116510",message:"Hi, Yonga & Simiyu Advocates",color:"#25D366",channel:"wa",boxShadow:"none",text:"Quick Chat",theme:"light",position:"right",mb:"20px",mx:"20px",radius:"20px"})})))}();</script>');
    }
    
    function printHeaderMain()
    {
        $class = "";
        if ($this->name == "index")
            $class = "header_whitecopy header_deeper";
    ?> 
    <header class="<?php echo($class); ?>" id="header_main">
        <div class="page_container">
            <div id="div_fixed_header">
                <h1>
                    <a href="index.php">
                        <img class="header_logo" src="img/Logo3.png" width="246" height="55" alt="Yonga & Simiyu">
                        Yonga & Simiyu
                    </a>                    
                </h1>
                <img id="img_logo_print" class="for_print" src="img/Logo3.png" width="246" height="55" alt="Yonga & Simiyu">

                <nav class="nav_primary">
                    <ul class=" nav_primary_ul_level_1">
                        <?php 
                        $i = 0;
                        foreach ($this->nav as $name=>$link) {
                            $li = '<li id="nav_primary_li_'.($i++).'">';
                            $li .= '<a href="'.$link.'.php" class="';
                            if ($link == $this->name)
                                $li .= 'selected';
                            $li .= '">'.$name.'<span class="mobile"></span></a></li>';
                            echo ($li."\n");
                        }
                        ?>
                    </ul>
                </nav>
                <nav class="nav_show">
                    <a href="<?php echo ($this->name); ?>.php" class="a_show_nav a_show">Show nav bar</a>
                </nav>
            </div>
        </div>
    </header>
    <?php
    }

    function printHeaderMarquee()
    {
    ?>
    <header class="" id="header_marquee">
        <div class="page_container">
            <div id="div_header_carousel">
                <div class="parsysheadercarousel parsys"></div>
            </div>
            <div class="div_image_container">
                <img id="img_main" src="img/<?php echo ($this->name); ?>_banner.png" width="1260" height="340" alt="<?php echo ($this->title); ?>&lt;br /&gt;">
            </div>
            <div id="header_h2_h3">
                <h2 style="color: <?php echo($this->headingColor); ?> !important;"><?php echo($this->title); ?><br></h2>
                <h3 style="color: <?php echo($this->headingColor); ?> !important;"><?php echo($this->meta); ?></h3>
            </div>
            <div class="parsysheadermarqueeinfo parsys"></div>
            <div class="messagecentre" style="display: none;"></div>
        </div>
    </header>
    <?php
    }

    function printMainContent()
    {}

    function printPageStyle ()
    {}

    function printMoreLinks ()
    {
    ?>
    <div class="clearfloat aem-GridColumn aem-GridColumn--default--12">
        <div style="display: block; width: 100%; height: 20px; clear: both; text-align: center;"></div>
    </div>
    <div class="jumpmenu aem-GridColumn aem-GridColumn--default--12">
        <article>
            <h2>Related information</h2>
            <label for="jumpmenu"><p>Who we are and how we work</p>
            </label>
            <select id="jumpmenu" name="jumpmenu">
                <option value="#">Please select</option>

                <option value="about_us.php#work">Who we are and how we work</option>
            
                <option value="about_us.php#clients_f">Delivering value to clients</option>

                <option value="team.php">Our team of experts</option>

                <option value="contact.php">Talk to us</option>
    
                <option value="careers.php">Careers</option>
            
                <option value="about_us.php#work">Inclusion</option>
            
                <option value="media.php">Media centre</option>
            
                <option value="about_us.php#work">Our story</option>
            
                <option value="about_us.php">Our Code</option>
            
                <option value="about_us.php">Risk and governance</option>
            
                <option value="contact.php">Stakeholder engagement</option>
                    
            </select>
        </article>
    </div>
    <?php
    }

    function printShareShow ()
    {
    ?>
    <div class="div_share_show" style="display:none">
        <div>
            <ul class="ul_sharing">
                <li class="li_sharing_twitter"><a href="https://twitter.com/intent/tweet?text=About%20Us&amp;url=https%3A%2F%2Fwww.yongaandsimiyu.com%2Fabout_us.php" target="_blank"><img src="img/Logo-X_Corp.png" width="40" height="40" alt="Share on Twitter"></a></li>
                <li class="li_sharing_linkedin"><a href="http://www.linkedin.com/shareArticle?mini=true&amp;url=https%3A%2F%2Fwww.yongaandsimiyu.com%2Fabout_us.php" target="_blank"><img src="img/hublinkedin.png" width="40" height="40" alt="Share on LinkedIn"></a></li>
                <li class="li_sharing_email"><a href="mailto:%20?subject=About%20Us&amp;body=https%3A%2F%2Fwww.yongaandsimiyu.com%2Fabout_us.php"><img src="img/hubemail.png" width="40" height="40" alt="Share via email"></a></li>
            </ul>
            <a href="<?php echo ($this->name); ?>.php#" id="a_back_to_top" title="back to top"><img src="img/hubbacktotop.png" width="40" height="40" alt="Back to top"></a>
        </div>
    </div>
    <?php
    }

    function printSectionTKOSP ()
    {
    ?>
    <div>
        <section id="section_tkosp" class="section_tkosp_login" data-maxheight="400" data-oktaorgurl="" data-oktacclogin="">
            <div class="page_container">
                <h2 id="h2_tkosp_button" style="background-color: #bd8620 !important;">
                    <a id="a_tkosp_button" href="<?php echo($this->name); ?>.php#" style="color: #fff; border-width: 0px;"><span class="span_hide550">Get Help &amp; </span>Contact Us</a>
                </h2>
                <ul id="ul_tkosp_toolkits_list">
                    <li>MNG Apartments, Ndemi Road -<br>Kilimani, Nairobi<a id="Client Portal" href="#">LOCATION</a>
                    </li>
                    <li>info@ yongaandsimiyu.com<br><br>advocates@ yongaandsimiyu.com<a id="Toolkit" href="mailto:info@yongaandsimiyu.com" target="_blank">EMAIL</a>
                    </li>
                    <li>linkedin.com/ yongaandsimiyu<a id="Blogs" href="#">LINKEDIN</a>
                    </li>
                    <li>+254 795 116 510 <br> +254 732 917 386<a id="Insights" href="tel:+254795116510">PHONE</a>
                    </li>                    
                </ul>
                <!-- Render the send email widget here -->
                <div id="okta-login-container">
                    <main data-se="auth-container" tabindex="-1" id="okta-sign-in" class="auth-container main-container no-beacon" style="">
                        <div class="okta-sign-in-header auth-header">
                            <div data-type="beacon-container" class="beacon-container"></div>
                        </div>
                        <div class="auth-content">
                            <div class="auth-content-inner">
                                <div class="primary-auth">
                                    <form method="POST" action="#" data-se="o-form" slot="content" id="sendEmailWidget" class=" o-form o-form-edit-mode">
                                        <div data-se="o-form-content" class="o-form-content o-form-theme clearfix">
                                            <h2 data-se="o-form-head" class="okta-form-title o-form-head">Contact Us</h2>
                                            <div class="o-form-error-container" data-se="o-form-error-container"></div>
                                            <div class="o-form-fieldset-container" data-se="o-form-fieldset-container">
                                                <div data-se="o-form-fieldset" class="o-form-fieldset o-form-label-top margin-btm-5">
                                                    <div data-se="o-form-label" class="okta-form-label o-form-label">
                                                        <label for="okta-signin-username">Your name&nbsp;</label>
                                                    </div>
                                                    <div data-se="o-form-input-container" class="o-form-input">
                                                        <span data-se="o-form-input-username" class="o-form-input-name-username o-form-control okta-form-input-field input-fix">
                                                            <input type="text" placeholder="Name" name="username" id="okta-signin-username" value="" aria-label="" autocomplete="username" aria-invalid="false" aria-required="true" required="required">
                                                        </span>
                                                    </div>
                                                </div>
                                                <div data-se="o-form-fieldset" class="o-form-fieldset o-form-label-top margin-btm-30">
                                                    <div data-se="o-form-label" class="okta-form-label o-form-label">
                                                        <label for="okta-signin-password">Your email&nbsp;</label>
                                                    </div>
                                                    <div data-se="o-form-input-container" class="o-form-input">
                                                        <span data-se="o-form-input-password" class="o-form-input-name-password o-form-control okta-form-input-field input-fix">
                                                            <input type="text" placeholder="Email" name="email" id="okta-signin-email" value="" aria-label="" autocomplete="email" aria-invalid="false" aria-required="true" required="required" title="Ensure email format is valid">
                                                        </span>
                                                    </div>
                                                </div>
                                                <div data-se="o-form-fieldset" class="o-form-fieldset o-form-label-top margin-btm-30">
                                                    <div data-se="o-form-label" class="okta-form-label o-form-label">
                                                        <label for="okta-signin-phone">Your number&nbsp;</label>
                                                    </div>
                                                    <div data-se="o-form-input-container" class="o-form-input">
                                                        <span data-se="o-form-input-password" class="o-form-input-name-password o-form-control okta-form-input-field input-fix">
                                                            <input type="text" placeholder="Phone" name="phone" id="okta-signin-phone" value="" aria-label="" autocomplete="email" aria-invalid="false" aria-required="true" required="required">
                                                        </span>
                                                    </div>
                                                </div>
                                                <div data-se="o-form-fieldset" class="o-form-fieldset o-form-label-top margin-btm-30">
                                                    <div data-se="o-form-label" class="okta-form-label o-form-label">
                                                        <label for="okta-signin-enquiry">Nature of enquiry&nbsp;</label>
                                                    </div>
                                                    <div data-se="o-form-input-container" class="o-form-input">
                                                        <span data-se="o-form-input-password" class="o-form-input-name-password o-form-control okta-form-input-field input-fix">
                                                            <select name="enquiry" style = "font-size: 14px; border: none; color: grey; width: 100%; height: 37px; padding-left: 10px;" id="okta-signin-enquiry" value="" aria-label="" aria-invalid="false" aria-required="true">
                                                                <option value="0">Please select</option>
                                                                <option value="General">General enquiry</option>
                                                                <option value="Legal">Legal services</option>
                                                                <option value="Media">Media enquiry</option>
                                                                <option value="Recruitment">Recruitment & work experience</option>
                                                                <option value="Report problem">Report a broken link or problem with our site</option>
                                                                <option value="Report fraud">Report fraud</option>
                                                            </select>
                                                        </span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="o-form-button-bar">
                                            <input class="button button-primary" type="submit" value="Send Email" id="okta-signin-submit" data-type="save">
                                        </div>
                                    </form>                                                                        
                                    <div class="registration-container">
                                        <div class="content-container">                                            
                                            <a title="Call an Advocate" aria-label="Sign up" class="registration-link" href="tel:+254715164772"><ins>Call Yonga & Simiyu Now</ins></a>
                                            
                                        </div>
                                        <div class="content-container">                                         
                                            <p id="form-error" style="color: #83f526; padding-top: 5px;"></a>
                                            <p id="send-success" style="color: #fff; padding-top: 5px;"></a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </main>
                </div>
                <!-- Or render the logged-in controls here -->
                <div id="okta-account-control" style="display: none;">
                    <!-- <ul>
                        <li><a style="background-image: url(/etc/designs/cc/images/cp-icon-pref.png);" href="#/client-portal.html">Client Portal</a></li>
                        <li><a style="background-image: url(/etc/designs/cc/images/cp-icon-account.png);" href="#/client-portal/forms/preference-form.html">Manage account and
                            preferences</a></li>
                        <li><a style="background-image: url(/etc/designs/cc/images/cp-icon-bookmark.png);" href="#/client-portal.html?bookmarks=true">Bookmarks</a></li>
                        <li><a style="background-image: url(/etc/designs/cc/images/cp-icon-logout.png);" href="#/client-portal.html" id="a_logout">Log-out</a></li>
                    </ul> -->
                </div>
                <!--

                <div style="position: absolute; bottom: 20px; left: 20px;">
                <p style="font-size: 14px; margin-bottom: 10px;"><strong>Create test users</strong></p>
                    <ul style="padding-left: 20px;">
                        <li><a class="a_createtestcookie" href="#" data-uid="0">User 0: Remove users and log-out.</a></li>
                        <li><a class="a_createtestcookie" href="#" data-uid="1">User 1: New user, no prefs or applications.</a></li>
                        <li><a class="a_createtestcookie" href="#" data-uid="2">User 2: Returning user, legal are, sector and jurisdiction prefs. No applications.</a></li>
                        <li><a class="a_createtestcookie" href="#" data-uid="3">User 3: Returning user, legal are, sector and jurisdiction prefs. CP approval pending.</a></li>
                        <li><a class="a_createtestcookie" href="#" data-uid="4">User 4: Returning user, legal are, sector and jurisdiction prefs. CP approval given.</a></li>
                        <li><a class="a_createtestcookie" href="#" data-uid="5">User 5: Simulate async cookie load from service (upgrades existing to CP approval given)</a></li>
                        <li><a class="a_createtestcookie" href="#" data-uid="6">User 6: Returning user, legal are, sector and jurisdiction prefs. CP approval given AND CBMCG.</a></li>
                    </ul>
                </div>

                -->
            </div>
        </section>
    </div>
    <?php
    }

    function printFooterMain ()
    {
    ?>
    <footer id="footer_main">
        <?php 
        if ($this->name != "privacy" && $this->name != "contact") { // privacy and contact pages don't have news 
        ?>
        <div class="div_footer_features">
            <div class="page_container">            
                            
                <!-- <h2><a href="media.php">News</a></h2>
                <ul id="ul_footer_features">
                    <li>    
                        <a href="#">
                            <span>Yonga & Simiyu highlights coming soon...</span><br>
                            News and highlights from Kenya and around the world coming soon. Stay tuned
                        </a>    
                    </li>                            
                    <li>    
                        <a href="#">
                        <span>Yonga & Simiyu highlights coming soon...</span><br>
                            News and highlights from Kenya and around the world coming soon. Stay tuned                            
                        </a>    
                    </li>                            
                    <li>    
                        <a href="#">
                        <span>Yonga & Simiyu highlights coming soon...</span><br>
                            News and highlights from Kenya and around the world coming soon. Stay tuned                            
                        </a>    
                    </li>                            
                    <li>    
                        <a href="#">
                        <span>Yonga & Simiyu highlights coming soon...</span><br>
                            News and highlights from Kenya and around the world coming soon. Stay tuned                            
                        </a>    
                    </li> -->
                </ul>                
            </div>            
        </div>
        <?php
        }
        ?>
        <div class="page_container" style="overflow: hidden;">
            <ul id="ul_footer">    
                <li class="li_copyright" style="float: right;">&#169; 2025 <a href="index.php">Yonga & Simiyu</a></li>
                     
                <li id="nav_footer_li_1">
                    <a href="about_us.php">
                    About Us
                    </a>
                </li>              
                <li id="nav_footer_li_2">
                    <a href="careers.php">
                    Careers
                    </a>
                </li>                        
                         
                <li id="nav_footer_li_3">
                    <a href="contact.php">
                    Contact Us
                    </a>
                </li>                
                             
                <li id="nav_footer_li_4">
                    <a href="https://www.termsfeed.com/live/69892f28-4839-4ed6-8a05-fe904049832a" target="_blank">
                    Privacy
                    </a>
                </li>                
                    
            </ul> 
            <ul class="ul_sharing">
                <li class="li_linkedin"><a href="#" rel="noopener noreferrer" target="_blank">Connect on LinkedIn</a></li>
                <li class="li_twitter"><a href="#" rel="noopener noreferrer" target="_blank">Follow us on Twitter</a></li>
                <li class="li_instagram"><a href="#" rel="noopener noreferrer" target="_blank">Follow us on Instagram</a></li>
                <li class="li_youtube"><a href="#" rel="noopener noreferrer" target="_blank">Follow us on YouTube</a></li>
                <li class="li_facebook"><a href="#" rel="noopener noreferrer" target="_blank">Join us on Facebook</a></li>      
            </ul>                    
            <script async="" src="js/siteanalyze_10168.js" class="optanon-category-C0002 " type="text/plain"></script> 
        </div>            
    </footer>
    <?php
    }

    function printFooterSticky ()
    {
    ?>
    <footer id="footersticky">
        <div class="parsysfootersticky iparsys parsys">
            <div class="section">
                <div class="new"></div>
            </div>
            <div class="iparys_inherited">
                <div class="parsysfootersticky iparsys parsys"></div>
            </div>
        </div>
    </footer>
    <?php
    }
}
?>